#if NUNIT
using System;
using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7.Parsers;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;
using gov.va.med.vbecs.DAL.HL7AL;

using gov.va.med.vbecs.UnitTests;

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.Parsers
{
	/// <summary>
	///
	/// </summary>
	[TestFixture]
    public class Parsers_CprsHL7Parser : BaseTest 

	{
		private HL7Interface intParms;
		private const string RBC_COMPONENT_ORDER = "2^RED BLOOD CELLS^99VBC^^";
		private const string FFP_COMPONENT_ORDER = "3^FRESH FROZEN PLASMA^99VBC^^";
		private const string CRYO_COMPONENT_ORDER = "5^CRYOPRECIPITATE^99VBC^^";
		private const string PLT_COMPONENT_ORDER = "4^PLATELETS^99VBC^^";
		private const string OTHER_COMPONENT_ORDER = "6^OTHER^99VBC^^";
		private const string WB_COMPONENT_ORDER = "11^WHOLE BLOOD^99VBC^^";
		private const string ABO_RH_TEST_ORDER = "7^ABO//RH^99VBC^^";
		private const string ABS_TEST_ORDER = "8^ABS^99VBC^^";
		private const string DAT_TEST_ORDER = "9^DAT^99VBC^^";
		private const string TAS_TEST_ORDER = "1^TAS^99VBC^^";
		private const string TRW_TEST_ORDER = "10^TRW^99VBC^^";
		private const string KC_DIVISION = "589^VA HEARTLAND - WEST, VISN 15";
		private const string WI_DIVISION = "589A7^WICHITA VAMC";
		

		[SetUp]
		public void SetUp()
		{
			intParms = new HL7Interface( InterfaceName.CPRS.ToString() );
		}

		[TearDown]
		public void TearDown()
		{}

		[Test]
		public void Test_ParseHL7Message_Pass_1()
		{
			int orderNum = HL7UnitTestUtil.GetRandomNumber(99999);
			int groupNum = orderNum - 1; 
			HL7ProtocolMessage ackMessage = CprsHL7Parser.ParseHL7Message( intParms, HL7UnitTestUtil.GetCprsMessage( "NW", orderNum.ToString(), groupNum.ToString(), TAS_TEST_ORDER, KC_DIVISION, HL7UnitTestUtil.GetRandomNumber(999999).ToString() ));

			Assert.AreEqual("AA", HL7Utility.ParseGetAckCode( ackMessage.GetMessage() ), "Ack Check" );
		}
		[Test]
		[ExpectedException( typeof( ArgumentNullException) )]
		public void Test_ParseHL7Message_Fail_1()
		{
			CprsHL7Parser.ParseHL7Message( intParms, null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException) )]
		public void Test_ParseHL7Message_Fail_2()
		{
			int orderNum = HL7UnitTestUtil.GetRandomNumber(99999);
			int groupNum = orderNum - 1;
			HL7ProtocolMessage ackMessage = CprsHL7Parser.ParseHL7Message( null, HL7UnitTestUtil.GetCprsMessage( "NW", orderNum.ToString(), groupNum.ToString(), TAS_TEST_ORDER, KC_DIVISION, HL7UnitTestUtil.GetRandomNumber(999999).ToString() ));
		}

		[Test]
		[ExpectedException( typeof( HL7Exception ) ) ]
		public void Test_ParseHL7Message_Fail_3()
		{
			int orderNum = HL7UnitTestUtil.GetRandomNumber(99999);
			int groupNum = orderNum - 1;
			HL7ProtocolMessage ackMessage = CprsHL7Parser.ParseHL7Message( new HL7Interface( InterfaceName.Patient_Update.ToString() ) , HL7UnitTestUtil.GetCprsMessage( "NW", orderNum.ToString(), groupNum.ToString(), TAS_TEST_ORDER, KC_DIVISION, HL7UnitTestUtil.GetRandomNumber(999999).ToString() ));
		}
	}
}
#endif